#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os, sys, site 
import datetime
import urllib
import urlparse
import re
import math
import codecs

from generator import *

from mako.template import Template
from mako.lookup import TemplateLookup

import web

TLOOKUP = TemplateLookup(   directories=[PANEO_SITE_DATA_DIR],
                            input_encoding='utf-8',
                            output_encoding='utf-8',
                            encoding_errors='replace', 
                            cache_impl='beaker',
                            cache_args={
                            },
                            imports = RENDER_IMPORTS    )

#from beaker.cache import CacheManager
#from beaker.util import parse_cache_config_options
#
#cache_opts = {
#    'cache.type': 'file',
#    'cache.data_dir': PANEO_SITE_DATA_DIR + '/_tmp/cache/data',
#    'cache.lock_dir': PANEO_SITE_DATA_DIR + '/_tmp/cache/lock'
#}
#cache = CacheManager(**parse_cache_config_options(cache_opts))
#if not HTML_CACHE:
#    beaker.cache.clear()
from beaker import cache

cachemg = cache.CacheManager(cache_regions={
'default' :{
        'type':'memcached',
        'url':'127.0.0.1:11211',
        'expiretime':1,
        'lock_dir': PANEO_SITE_DATA_DIR + '/_tmp/cache/file/lock'
    }
})

class View:

    def __init__(self):
        web.header("Content-Type", "text/javascript; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    #@cache.cachemg(expire=1)
    def GET(self,id="index"):

        filename = PANEO_SITE_DATA_DIR + ( '/common/js/%s.js' % id )
        if os.path.exists( filename ):
            file = codecs.open(filename,"r","utf8")
            js = file.read()
            template = Template(    
                                    js,
                                    lookup=TLOOKUP,
            )
            return template.render(
                                    PANEO_WIDTH = PANEO_WIDTH,
                                    PANEO_HEIGHT = PANEO_HEIGHT,
                                    TABLET_WIDTH = TABLET_WIDTH,
                                    SMART_PHONE_WIDTH = SMART_PHONE_WIDTH,
            )

        return "javascirpt no file" 

